/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.VerificationException;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.net.NetworkUtility;
import oracle.install.commons.net.NetworkUtilityException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.install.library.util.cvu.CVUValidationStatusMessage;

public class SupportedOSValidator
implements Validator {
    private static Logger logger = Logger.getLogger(SupportedOSValidator.class.getName());

    protected StatusMessages<ErrorMessage> verifyEnvironment() throws Exception {
        logger.log(Level.INFO, "Verifying target environment...");
        StatusMessages errorMessages = new StatusMessages();
        try {
            NetworkUtility utility = NetworkUtility.getInstance();
            logger.log(Level.INFO, "Checking whether the IP address of the localhost could be determined...");
            utility.getLocalHostName();
            CVUHelper cvu = CVUHelper.getInstance();
            if (!cvu.isPreReqSupported()) {
                errorMessages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
            }
        }
        catch (NetworkUtilityException e) {
            logger.log(Level.SEVERE, "Unable to determine a valid IP for the localhost.", e);
            errorMessages.add((StatusMessage)new DefaultErrorMessage((Throwable)e));
        }
        catch (PreReqNotSupportedException e) {
            logger.log(Level.SEVERE, "CVU do not support target environment.", e);
            errorMessages.add((StatusMessage)new DefaultErrorMessage((Throwable)e, (ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
        }
        catch (VerificationException e) {
            logger.log(Level.SEVERE, "Error while verifying whether the target environment is supported by CVU or not.", e);
            errorMessages.add((StatusMessage)new DefaultErrorMessage((Throwable)e, (ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unexpected runtime-error while verifying whether the target environment is supported by CVU or not.", t);
            errorMessages.add((StatusMessage)new DefaultErrorMessage(t, (ErrorCode)PrereqCheckerErrorCode.INSTALL_CVU_EXECUTION_NOT_POSSIBLE, new Object[0]));
        }
        logger.log(Level.INFO, "Completed verification of target environment.");
        return errorMessages;
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        Application application = Application.getInstance();
        if (DriverHelper.isCVUEnabled()) {
            if (!application.getArguments().contains("-ignorePrereq")) {
                StatusMessages<ErrorMessage> errorMessages = null;
                try {
                    errorMessages = this.verifyEnvironment();
                }
                catch (Throwable e) {
                    ExceptionManager.handle((Throwable)e);
                }
                if (errorMessages != null && !errorMessages.isEmpty()) {
                    logger.log(Level.WARNING, "Verification of target environment returned with errors.");
                    Advice advice = ExceptionManager.advise(errorMessages);
                    if (advice == Advice.ABORT || advice == Advice.WITHDRAW) {
                        logger.log(Level.WARNING, "Advised to shutdown the installer due to target environment verification errors.");
                        application.shutdown((ExitStatus)OUIExitStatus.PREREQ_FAILURE);
                    } else {
                        logger.log(Level.WARNING, "Advised to ignore target environment verification errors.");
                        application.setAttribute("isCVUPrereqExecutionNotSupportedForOS", (Object)Boolean.TRUE);
                    }
                }
            }
            GenericValidation.validateForCVUFrameworkSetup(new String[0]);
        } else {
            application.setAttribute("isCVUPrereqExecutionNotSupportedForOS", (Object)Boolean.TRUE);
        }
    }
}

